/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.lad.cutpointSelection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.rules.lad.core.BinaryData;
import weka.classifiers.rules.lad.core.BinaryInstance;
import weka.classifiers.rules.lad.cutpointSelection.FeatureSelection;
import weka.classifiers.rules.lad.setCovering.SetCovering;
import weka.core.Option;
import weka.core.Utils;

public class IteratedSampling
extends FeatureSelection {
    private static final long serialVersionUID = 1557597598188635948L;
    private int mNumSamples = 100;
    private double mSampleSize = 0.1;
    private int mSolutionSize = 30;
    private long mSeed = 2L;
    private boolean fSampleCutpoints = false;
    private Random mRnd = new Random(this.mSeed);

    @Override
    public void findSelectedAtts(BinaryData bInsts) {
        this.mSelectedAttArray = new ArrayList();
        if (this.mSeparationLevel <= 0) {
            int i = 0;
            while (i < bInsts.numAttributes()) {
                this.mSelectedAttArray.add(i);
                ++i;
            }
            return;
        }
        if (this.fSampleCutpoints) {
            this.sampleCutpointsMode(bInsts);
        } else {
            this.notSampleCutpointsMode(bInsts);
        }
    }

    private void sampleCutpointsMode(BinaryData bInsts) {
        int numRSCutpoints = (int)((double)bInsts.numAttributes() * this.mSampleSize);
        int numRSPInsts = (int)((double)bInsts.numPositiveInstances() * (this.mSampleSize / 2.0));
        int numRSNInsts = (int)((double)bInsts.numNegativeInstances() * (this.mSampleSize / 2.0));
        ArrayList<Integer> array = new ArrayList<Integer>(numRSCutpoints);
        int[] cutpointsIDs = new int[numRSCutpoints];
        int[] negativeIDs = new int[numRSNInsts];
        int[] positiveIDs = new int[numRSPInsts];
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        HashMap<Integer, Object> vPers = new HashMap<Integer, Object>(numRSCutpoints);
        SetCovering sc = null;
        int i = 0;
        while (i < this.mNumSamples) {
            int aux;
            map.clear();
            while (map.size() < numRSCutpoints) {
                aux = this.mRnd.nextInt(bInsts.numAttributes());
                if (map.containsKey(aux)) continue;
                cutpointsIDs[map.size()] = aux;
                map.put(aux, aux);
            }
            map.clear();
            while (map.size() < numRSPInsts) {
                aux = this.mRnd.nextInt(bInsts.numPositiveInstances());
                if (map.containsKey(aux)) continue;
                positiveIDs[map.size()] = aux;
                map.put(aux, aux);
            }
            map.clear();
            while (map.size() < numRSNInsts) {
                aux = this.mRnd.nextInt(bInsts.numNegativeInstances());
                if (map.containsKey(aux)) continue;
                negativeIDs[map.size()] = aux;
                map.put(aux, aux);
            }
            sc = new SetCovering(numRSCutpoints);
            int p = 0;
            while (p < positiveIDs.length) {
                BinaryInstance pInst = bInsts.getPositiveInstance(positiveIDs[p]);
                int n = 0;
                while (n < negativeIDs.length) {
                    BinaryInstance nInst = bInsts.getNegativeInstance(negativeIDs[n]);
                    array.clear();
                    int c = 0;
                    while (c < cutpointsIDs.length) {
                        if (!pInst.compareAtt(cutpointsIDs[c], nInst)) {
                            array.add(c);
                        }
                        ++c;
                    }
                    sc.addElement(array);
                    ++n;
                }
                ++p;
            }
            sc.solve(this.mSeparationLevel);
            int c = 0;
            while (c < cutpointsIDs.length) {
                Object p2 = (Persistence)vPers.get(cutpointsIDs[c]);
                if (p2 == null) {
                    p2 = new Persistence(cutpointsIDs[c]);
                    vPers.put(((Persistence)p2).id, p2);
                }
                ++((Persistence)p2).numSamples;
                ++c;
            }
            for (Integer s : sc.getSolution()) {
                Persistence p3 = (Persistence)vPers.get(cutpointsIDs[s]);
                ++p3.numSelections;
            }
            ++i;
        }
        ArrayList cPers = new ArrayList(vPers.values());
        Collections.sort(cPers);
        int k = this.mSolutionSize > bInsts.numAttributes() ? bInsts.numAttributes() : this.mSolutionSize;
        int i2 = 0;
        while (i2 < k) {
            this.mSelectedAttArray.add(((Persistence)cPers.get((int)i2)).id);
            ++i2;
        }
    }

    private void notSampleCutpointsMode(BinaryData bInsts) {
        int numRSPInsts = (int)((double)bInsts.numPositiveInstances() * (this.mSampleSize / 2.0));
        int numRSNInsts = (int)((double)bInsts.numNegativeInstances() * (this.mSampleSize / 2.0));
        ArrayList<Integer> array = new ArrayList<Integer>(bInsts.numAttributes());
        int[] negativeIDs = new int[numRSNInsts];
        int[] positiveIDs = new int[numRSPInsts];
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        HashMap<Integer, Persistence> vPers = new HashMap<Integer, Persistence>(bInsts.numAttributes());
        int i = 0;
        while (i < bInsts.numAttributes()) {
            vPers.put(i, new Persistence(i, this.mNumSamples, 0));
            ++i;
        }
        SetCovering sc = null;
        int i2 = 0;
        while (i2 < this.mNumSamples) {
            int aux;
            map.clear();
            while (map.size() < numRSPInsts) {
                aux = this.mRnd.nextInt(bInsts.numPositiveInstances());
                if (map.containsKey(aux)) continue;
                positiveIDs[map.size()] = aux;
                map.put(aux, aux);
            }
            map.clear();
            while (map.size() < numRSNInsts) {
                aux = this.mRnd.nextInt(bInsts.numNegativeInstances());
                if (map.containsKey(aux)) continue;
                negativeIDs[map.size()] = aux;
                map.put(aux, aux);
            }
            sc = new SetCovering(bInsts.numAttributes());
            int p = 0;
            while (p < positiveIDs.length) {
                BinaryInstance pInst = bInsts.getPositiveInstance(positiveIDs[p]);
                int n = 0;
                while (n < negativeIDs.length) {
                    BinaryInstance nInst = bInsts.getNegativeInstance(negativeIDs[n]);
                    array.clear();
                    int c = 0;
                    while (c < bInsts.numAttributes()) {
                        if (!pInst.compareAtt(c, nInst)) {
                            array.add(c);
                        }
                        ++c;
                    }
                    sc.addElement(array);
                    ++n;
                }
                ++p;
            }
            sc.solve(this.mSeparationLevel);
            for (Integer s : sc.getSolution()) {
                Persistence p2 = (Persistence)vPers.get(s);
                ++p2.numSelections;
            }
            ++i2;
        }
        ArrayList cPers = new ArrayList(vPers.values());
        Collections.sort(cPers);
        int k = this.mSolutionSize > bInsts.numAttributes() ? bInsts.numAttributes() : this.mSolutionSize;
        int i3 = 0;
        while (i3 < k) {
            this.mSelectedAttArray.add(((Persistence)cPers.get((int)i3)).id);
            ++i3;
        }
    }

    @Override
    public void checkForExceptions() throws Exception {
        super.checkForExceptions();
        if (this.mNumSamples < 10) {
            throw new Exception("Feature Selection: Number of samples must be at least 10.");
        }
        if (this.mSampleSize < 0.05) {
            throw new Exception("Feature Selection: Sample size must be at least 0.05.");
        }
        if (this.mSolutionSize < 1) {
            throw new Exception("Feature Selection: Solution size must be at least 1.");
        }
    }

    public int getNumSamples() {
        return this.mNumSamples;
    }

    public void setNumSamples(int numSamples) {
        if (numSamples >= 1) {
            this.mNumSamples = numSamples;
        }
    }

    public double getSampleSize() {
        return this.mSampleSize;
    }

    public void setSampleSize(double size) {
        if (size >= 0.05 && size <= 1.0) {
            this.mSampleSize = size;
        }
    }

    public int getSolutionSize() {
        return this.mSolutionSize;
    }

    public void setSolutionSize(int solutionSize) {
        if (solutionSize >= 1) {
            this.mSolutionSize = solutionSize;
        }
    }

    public long getRandomSeed() {
        return this.mSeed;
    }

    public void setRandomSeed(long seed) {
        this.mSeed = seed;
    }

    public void setSampleCutpoints(boolean flag) {
        this.fSampleCutpoints = flag;
    }

    public boolean getSampleCutpoints() {
        return this.fSampleCutpoints;
    }

    @Override
    public String globalInfo() {
        return "Iterative procedure for selecting a set of cutpoints that separates a large number of pairs of observations. The technique samples the (possibly very large) cutpoint selection problem, producing a set cover problem of smaller size (both in terms of constraints and variables). A greedy solution is found for the subproblem and the process is iterated. The cutpoints that are most frequently selected to take part in the greedy solutions are returned.";
    }

    public String numSamplesTipText() {
        return "This is the number of times the cutpoint selection problem will be sampled.";
    }

    public String sampleSizeTipText() {
        return "This specifies the fraction of the cutpoint selection problem that is sampled in order to create each subproblem. The same percentage factor is used to sample a subset of the constraints (pairs of observations) of the cutpoint selection problem. Half of the observations selected are positive, half are negative, and all pairs are used as constraints. If \"sampleCutpoints\" is set to true, a subset of the problem's variables (cutpoints) is also sampled. In either case, sampling is done uniformly and without replacement.";
    }

    public String solutionSizeTipText() {
        return "Number of cutpoints returned by the procedure. The best ranked cutpoints (with respect to frequency of participation in solutions) are returned.";
    }

    public String randomSeedTipText() {
        return "Value used as seed to the pseudo-random number generator employed during the sampling process.";
    }

    public String sampleCutpointsTipText() {
        return "Flag indicating whether or not cutpoints are sampled (in addition to observations) when forming each subproblem. If set to false, all cutpoints separating the sampled observations are included in the subproblem.";
    }

    @Override
    public String separationLevelTipText() {
        return "Separation requirement for cutpoint selection. Every pair of observations in a subproblem must be separated by a minimum number of cutpoints.";
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-fsl");
        options.add("" + this.getSeparationLevel());
        options.add("-nsp");
        options.add("" + this.getNumSamples());
        options.add("-fss");
        options.add("" + this.getRandomSeed());
        options.add("-sps");
        options.add("" + this.getSampleSize());
        options.add("-sls");
        options.add("" + this.getSolutionSize());
        options.add("-scm");
        options.add("" + this.getSampleCutpoints());
        return options.toArray(new String[options.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String numSamplesOption;
        String featureSelSeparationLevelOption = Utils.getOption("fsl", options);
        if (featureSelSeparationLevelOption.length() != 0) {
            this.setSeparationLevel(Integer.parseInt(featureSelSeparationLevelOption));
        }
        if ((numSamplesOption = Utils.getOption("nsp", options)).length() != 0) {
            this.setNumSamples(Integer.parseInt(numSamplesOption));
        }
        String randomSeedOption = Utils.getOption("fss", options);
        if (numSamplesOption.length() != 0) {
            this.setRandomSeed(Integer.parseInt(randomSeedOption));
        }
        String sampleSizeOption = Utils.getOption("sps", options);
        if (numSamplesOption.length() != 0) {
            this.setSampleSize(Double.parseDouble(sampleSizeOption));
        }
        String solutionSizeOption = Utils.getOption("sls", options);
        if (numSamplesOption.length() != 0) {
            this.setSolutionSize(Integer.parseInt(solutionSizeOption));
        }
        String sampleCutpointsOption = Utils.getOption("scm", options);
        if (numSamplesOption.length() != 0) {
            this.setSampleCutpoints(Boolean.parseBoolean(sampleCutpointsOption));
        }
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tFeature selection separation level. How many times each\n\tpair of observations should be separated by cutpoints.\n\t(Default = 0, i.e., no separation required)\n", "fsl", 1, "-fsl <separation_level>"));
        newVector.addElement(new Option("\tThis is the number of times the cutpoint selection problem\n\twill be sampled.\n", "nsp", 1, "-nsp <number_of_samples>"));
        newVector.addElement(new Option("\tValue used as seed to the pseudo-random number\n\tgenerator employed during the sampling process.\n", "fss", 1, "-fss <seed>"));
        newVector.addElement(new Option("\tThis specifies the fraction of the cutpoint selection problem \n\tthat is sampled in order to create each subproblem. The \n\tsame percentage factor is used to sample a subset of the \n\tconstraints (pairs of observations) of the cutpoint selection \n\tproblem. Half of the observations selected are positive, \n\thalf are negative, and all pairs are used as constraints. \n\tIf \"sampleCutpoints\" is set to true, a subset of the problem's \n\tvariables (cutpoints) is also sampled. In either case, \n\tsampling is done uniformly and without replacement.\n", "sps", 1, "-sps <sample_size>"));
        newVector.addElement(new Option("\tNumber of cutpoints returned by the procedure.\n\tThe best ranked cutpoints (with respect to\n\tfrequency of participation in solutions) are returned.\n", "sls", 1, "-sls <seed>"));
        newVector.addElement(new Option("\tFlag indicating whether or not cutpoints are sampled (in addition \n\tto observations) when forming each subproblem. If set to false, \n\tall cutpoints separating the sampled observations are included \n\tin the subproblem.\n", "sps", 1, "-scm <boolean>"));
        return newVector.elements();
    }

    private class Persistence
    implements Comparable<Persistence>,
    Serializable {
        private static final long serialVersionUID = -6177074127558835505L;
        final int id;
        int numSamples;
        int numSelections;

        public Persistence(int id) {
            this(id, 0, 0);
        }

        public Persistence(int id, int numSamples, int numSelections) {
            this.id = id;
            this.numSamples = numSamples;
            this.numSelections = numSelections;
        }

        public double quality() {
            if (this.numSamples == 0) {
                return 0.0;
            }
            return (double)this.numSelections / (double)this.numSamples;
        }

        @Override
        public int compareTo(Persistence p) {
            if (this.quality() < p.quality()) {
                return 1;
            }
            if (this.quality() > p.quality()) {
                return -1;
            }
            if (this.numSamples < p.numSamples) {
                return 1;
            }
            if (this.numSamples > p.numSamples) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "" + this.quality();
        }
    }
}

